
import { CustomerEditWidget } from '../../customers/CustomerEditWidget.js';


export class SalesCheckoutCustomerWidget {
	
	
	tpl = `
		<div class="page-header">
		
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.prevPage" class="fa fa-chevron-circle-left"></a>
				<a href="javascript:void(0);" [onclick]="widget.nextPage" class="fa fa-chevron-circle-right"></a>
			</div>
		
			<h1>Checkout</h1>
		</div>
		
		<div class="action-box">
			<span class="search-customer" style="display:none;"><a href="javascript:void(0);" [onclick]="widget.searchCustomer_Click">Klant zoeken</a></span>
			<span class="new-customer"><a href="javascript:void(0);" [onclick]="widget.newCustomer_Click">Nieuwe klant</a></span>
		</div>
		
		<hr class="clear" />
		
		<div id="sales-create-customer" class="sales-create-customer hidden"></div>
		
		<div id="sales-checkout-customer-widget" class="sales-checkout-customer-widget">
		
			Voer klantnaam in
			
			<div>
				<input type="text" class="customer-lookup-create" autocomplete="off" name="n" value="" placeholder="Klantnaam" />
			</div>
			
			<div ez-subtemplate="customer-list">
				<div ez-if="customers != null && customers.length == 0" class="no-results">
					Geen resultaten gevonden
				</div>
				
				<div ez-if="customers != null && customers.length > 0">
					<table class="table">
						<thead>
							<tr>
								<th>Klant type</th>
								<th>Klantnaam</th>
								<th>Contactpersoon</th>
								<th>Adres</th>
								<th>Telefoonnr</th>
								<th>E-mail</th>
							</tr>
						</thead>
						<tbody ez-for="customers" ez-item="c">
							<tr [onclick]="widget.selectCustomer" [customer]="c" class="pointer">
								<td>{{ _('customer_type.'+c.customerType) }}</td>
								<td>{{ c.customerName }}</td>
								<td>{{ c.contactPerson ?? '' }}</td>
								<td>
									<span ez-if="c.addresses != null && c.addresses.length > 0">
										{{ c.addresses[0].street }}
										{{ c.addresses[0].streetNo }}
										{{ c.addresses[0].city }}
									</span>
								</td>
								<td>
									<span ez-if="c.phones != null && c.phones.length > 0">
										{{ c.phones[0].phonenr }}
									</span>
								</td>
								<td>
									<span ez-if="c.emails != null && c.emails.length > 0">
										{{ c.emails[0].emailAddress }}
									</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	`;
	
	
	container = null;
	
	
	ezTpl = null;
	uid = null;
	session = null;
	
	customers = null;
	
	formMode = 'search';
	
//	callback_customerSelected = null;

	customerEditWidget = null;
	
	lastSearch = '';
	
	
	constructor( scw ) {
		this.uid = scw.uid;
		this.session = scw.session;
	}


	
	init(c) {
		this.container = c;
		
		if ( this.session == null ) {
			reportUserMessage( 'Checkout session not found' );
			gotoRoute( '/sales/salesplan/' );
			return;
		}
		
	}
	
	
//	setCallbackCustomerSelected(callback) {
//		this.callback_customerSelected = callback;
//	}
	
	
	prevPage() {
		this.uid = getUrlParam('uid');
		this.saveSession();
		
		gotoRoute( '/sales/salesplan/checkout/?uid=' + this.uid);
	}
	
	nextPage() {
		// validate
		
		
		// existing customer selected? => continue
		if ( this.formMode == 'search' && this.session.customer && this.session.customer.customerId ) {
			this.session.customerMode = 'existing';
			this.saveSession();
			
			gotoRoute( '/sales/salesplan/checkout/overview/?uid=' + this.uid);
		}
		// new customer? => validate
		else {
			this.session.customerMode = 'new';
			this.session.newCustomer = this.customerEditWidget.getCustomer();
			
			this.saveSession();
			
			
			this.customerEditWidget.validate(
				(json) => {				// success
					gotoRoute( '/sales/salesplan/checkout/overview/?uid=' + this.uid);
				}
			)
			
		}
		
		
//		gotoRoute( '/sales/salesplan/?uid=' + this.uid);
	}
	
	setFormMode( m ) {
		
		if (m != 'search' && m != 'new') {
			console.log('setFormMode(): invalid mode', m);
			return;
		}
		
		this.formMode = m;
		this.session.customerFormMode = m;
		this.saveSession();
		
		if (this.formMode == 'search') {
			$('#sales-checkout-customer-widget').show();
			$('#sales-create-customer').hide();
		
			$('.action-box .new-customer').show();
			$('.action-box .search-customer').hide();
			console.log('searchio');
		}
		
		if (this.formMode == 'new') {
			console.log('zznew..', this.formMode, m, this.formMode == 'new');
			console.log('len', $('#sales-create-customer').length);
			$('#sales-checkout-customer-widget').hide();
			$('#sales-create-customer').show();
			$('#sales-create-customer').removeClass('hidden');
			
			$('.action-box .new-customer').hide();
			$('.action-box .search-customer').show();
		}
	}
	
	saveSession() {
		setSession('co_'+this.uid, this.session);
	}
	
	
	
	searchCustomer( opts ) {
		opts = opts ? opts : {};
		
		let v = $.trim( $('.customer-lookup-create').val() );
		
		if (opts.customerId) {
			
		}
		else {
			if (this.lastSearch == v)
				return;
			this.lastSearch = v;
		}
		
		let data = {};
		data.a = 'search';
		data.q = v;
		
		if (opts.customerId) {
			data.customerId = opts.customerId;
		}
		
		
		postUrl('/service/customers.do', data )
		.then( async function(e) {
			let json = await e.json();
			this.setCustomers( json.customers );
		}.bind(this) );
	}
	
	
	setCustomers( customers ) {
		this.customers = customers;
		this.ezTpl.setVar('customers', this.customers);
		
		let tpl = document.querySelector('[ez-subtemplate=customer-list]').eztemplate;
		console.log('tpl', tpl);
		tpl.setVar('customers', this.customers);
		tpl.render();
		
	}
	
	newCustomer_Click() {
		let customerName = $('.customer-lookup-create').val();
		
		this.customerEditWidget.setCustomerName( customerName );
		
		this.setFormMode( 'new' );
	}
	
	searchCustomer_Click() {
		this.setFormMode( 'search' );
	}
	
	selectCustomer(evt) {
		let c = evt.currentTarget.customer
		
		this.session.customerMode = 'existing';
		this.session.customer = c;
		this.saveSession();
		
		this.nextPage();
	}
	
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.setVar('customers', this.customers);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		// create customer-edit widget
		if (this.customerEditWidget == null) {
			this.customerEditWidget = new CustomerEditWidget();
			this.customerEditWidget.setCustomerName( document.querySelector('.customer-lookup-create').value );
			
			console.log(this.session);
			if (this.session.newCustomer) {
				this.customerEditWidget.setCustomer( this.session.newCustomer );
			}
			
			this.customerEditWidget.init( document.querySelector('#sales-create-customer') );
		}
		else {
			this.customerEditWidget.container = document.querySelector('#sales-create-customer');
			this.customerEditWidget.render();
		}
		
		$('#sales-create-customer .page-header').hide();
		
		
		// set events
		if (this.formMode == 'search')
			$('.customer-lookup-create').focus();
		
		$('.customer-lookup-create').on('change keyup', function(evt) {
			this.searchCustomer();
		}.bind(this));
		
		
		if (this.session.customerFormMode && this.session.customerFormMode == 'new') {
			this.setFormMode('new');
		}
		else {
			this.setFormMode('search');
			
			// customer set? => show
			if (this.session.customer && this.session.customer.customerId) {
				this.searchCustomer({
					customerId: this.session.customer.customerId
				});
			}
		}

	}

}


